//
//  MCMiniMonthView.h
//  MCApplication
//
//  Created by Michael Clark on 20/02/06.
//  Copyright 2006 __MyCompanyName__. All rights reserved.
//

#import <Cocoa/Cocoa.h>

#import <MCFoundation/NSCalendarDate+MCAdditions.h>



// Defines for the bindings - they define indices into the various C style areas for keeping track of the necessary things
#define   MCMiniMonthViewBindingCount              1
#define   MCMiniMonthViewSelectedDateBinding    0x00
//... define more as necessary



@class MCDateRange;

@interface MCMiniMonthView : NSView {
	
	NSCalendarDate*     __selectedDate;
	NSCalendarDate*     __visibleDate;  // Private date used for drawing calculations
	MCDateRange*        __visibleDayRange;
	
	MCDayOfWeek         __weekStartDay;
	
	NSMutableArray*     __headerStrings;
	
	SEL    action;
	SEL    doubleAction;
	id     target;
	
	BOOL  __showSelectedDate;  // This allows you to use the selected date for the visible month and not show selection (Hack!) defaults to YES
	
	// Bindings support
	id          __observedObjects[MCMiniMonthViewBindingCount];
	NSString*   __observedKeyPaths[MCMiniMonthViewBindingCount];	
	BOOL __selfSet;  // Stupid - flag used to prevent us from being updated when we trigger a bindings change
}






- (int)monthOfYear;
- (int)yearOfCommonEra;

- (SEL)action;
- (void)setAction:(SEL)anAction;
- (SEL)doubleAction;
- (void)setDoubleAction:(SEL)aDoubleAction;
- (id)target;
- (void)setTarget:(id)aTarget;

- (NSCalendarDate *)selectedDate;
- (void)setSelectedDate:(NSCalendarDate *)aSelectedDate;

- (MCDayOfWeek)weekStartDay;
- (void)setWeekStartDay:(MCDayOfWeek)aWeekStartDay;

- (MCDateRange *)visibleDayRange;
- (void)setVisibleDayRange:(MCDateRange *)aVisibleDayRange;

- (BOOL)showSelectedDate;
- (void)setShowSelectedDate:(BOOL)flag;


@end
